function jedanaesti_zadatak( )
clear;
% Filip Ilic 074/02
% Program za zadatu tacnost iterativnom metodom i modifikovanom iterativnom metodom 
% nalazi resenje zadate jednacine 4*exp(x) - 5*(x + 1) = 0
% i graficki prikazuje zavisnost brzine konvergencije od trazene tacnosti.

hold on;
fplot( '4*exp(x)', [-2, 2], 'b' );
fplot( '5*(x+1)', [-2, 2], 'r' );
hold off;


eps = input( 'Unesite zeljenu tacnost:\n' );
ispisi = 1;

% iterativna metoda
a_1 = -0.7;
b_1 = -0.2;
q_1 = 0.6550;
kriterijum_zaustavljanja_1 = (1 - q_1)./q_1 * eps;

a_2 = 0.5;
b_2 = 1;
q_2 = 0.5;
kriterijum_zaustavljanja_2 = (1 - q_2)./q_2 * eps;

disp( 'Resenja dobijena metodom proste iteracije: ' );
broj_potrebnih_iteracija = iterativna_metoda( a_1, b_1, kriterijum_zaustavljanja_1, 1, ispisi )
broj_potrebnih_iteracija = iterativna_metoda( a_2, b_2, kriterijum_zaustavljanja_2, 0, ispisi )

%modifikovana iterativna metoda
M_1 = -3.0137;
m_1 = -1.7251;
p_1 = (M_1 - m_1)./(M_1 + m_1);
kriterijum_modifikovanog_zaustavljanja_1 = (1 - p_1)./p_1 * eps;
lambda_1 = 2./(M_1 + m_1);

M_2 = 5.8731;
m_2 = 1.5949;
p_2 = (M_2 - m_2)./(M_2 + m_2);
kriterijum_modifikovanog_zaustavljanja_2 = (1 - p_2)./p_2 * eps;
lambda_2 = 2./(M_2 + m_2);

disp( 'Resenja dobijena modifikovanom iterativnom metodom: ' );
broj_potrebnih_iteracija = modifikovana_iterativna_metoda ( a_1, b_1, lambda_1, kriterijum_modifikovanog_zaustavljanja_1, ispisi )
broj_potrebnih_iteracija = modifikovana_iterativna_metoda ( a_2, b_2, lambda_2, kriterijum_modifikovanog_zaustavljanja_2, ispisi )


%%%%%%%%%%%%% graficki prikaz zavisnosti brzine konvergencije od trazene tacnosti %%%%%%%%%%%%%%%
ispisi = 0;
trazena_tacnost = 0.0000001:4*0.0000001:0.001;
n = length(trazena_tacnost);
 
for i=1:n
   kriterijum_zaustavljanja_1 = (1 - q_1)./q_1 * trazena_tacnost(i);
   kriterijum_zaustavljanja_2 = (1 - q_2)./q_2 * trazena_tacnost(i);
   broj_iteracija_1(i) = iterativna_metoda( a_1, b_1, kriterijum_zaustavljanja_1, 1, ispisi );
   broj_iteracija_2(i) = iterativna_metoda( a_2, b_2, kriterijum_zaustavljanja_2, 0, ispisi );

   kriterijum_modifikovanog_zaustavljanja_1 = (1 - p_1)./p_1 * trazena_tacnost(i);
   kriterijum_modifikovanog_zaustavljanja_2 = (1 - p_2)./p_2 * trazena_tacnost(i);
   broj_modifikovanih_iteracija_1(i) = modifikovana_iterativna_metoda( a_1, b_1, lambda_1, kriterijum_modifikovanog_zaustavljanja_1, ispisi );
   broj_modifikovanih_iteracija_2(i) = modifikovana_iterativna_metoda( a_2, b_2, lambda_2, kriterijum_modifikovanog_zaustavljanja_2, ispisi );
end
 
plot( broj_iteracija_1, trazena_tacnost, '--r' );
hold on
plot( broj_iteracija_2, trazena_tacnost, '--b' );
plot( broj_modifikovanih_iteracija_1, trazena_tacnost, 'r' );
plot( broj_modifikovanih_iteracija_2, trazena_tacnost, 'b' );

function broj_iteracija = iterativna_metoda( a, b, kriterijum_zaustavljanja, nula, ispisi )
x_0 = (a + b)/2;
x_1 = 0;
broj_iteracija = 0;
while( 1 )
    if( nula )
        x_1 = 4/5*exp(x_0) - 1; % za prvu nulu
    else
        x_1 = log((5/4)*(x_0 + 1) ); % za drugu nulu
    end
    
    if( abs(x_1 - x_0) < kriterijum_zaustavljanja )
        break;
    else
        broj_iteracija = broj_iteracija + 1;
        x_0 = x_1;
    end
end
if( ispisi )
    trazeno_x = x_1
end

function broj_iteracija = modifikovana_iterativna_metoda( a, b, lambda, kriterijum_zaustavljanja, ispisi )
x_0 = (a+b)/2;
x_1 = 0;
broj_iteracija = 0;
while( 1 )
    x_1 = x_0 - lambda * (4*exp(x_0) - 5*(x_0 + 1));
    if( abs(x_1 - x_0) < kriterijum_zaustavljanja )
        break;
    else
        broj_iteracija = broj_iteracija + 1;
        x_0 = x_1;
    end
end
if( ispisi )
    trazeno_x = x_1
end